# 🧠 HIWOSY™ QUICK REFERENCE
### One-Page Cheat Sheet

---

## ⚡ Run in 30 Seconds

```bash
pip install -r requirements.txt
python test_my_data.py sample_data.csv
```

---

## ⚠️ FIRST COLUMN RULE

**Your text data MUST be in the FIRST column!**

✅ Correct:
```csv
message,id,date
"Hello world",1,2026-01-09
```

❌ Wrong:
```csv
id,date,message
1,2026-01-09,"Hello world"
```

**OR specify column:** `--column "message"`

---

## 🎯 3 Products Explained

| # | Product | Input | Output |
|---|---------|-------|--------|
| 1 | **Dedup** | Any text | UNIQUE / DUPLICATE |
| 2 | **Cache** | Any text | MASTER / MERGE |
| 3 | **Toxicity** | Any text | SAFE / BAN / WARN |

---

## 📊 Understanding Results

### Deduplication Status
- **UNIQUE** = First occurrence → Keep
- **DUPLICATE** = Similar exists → Merge

### Cache Status  
- **MASTER** = New query → Cache it
- **MERGE** = Similar cached → Use cache

### Toxicity Action
- **SAFE** = Allow ✅
- **MONITOR** = Watch 👁️
- **WARNING** = Caution ⚠️
- **BAN** = Block 🚫

---

## 🛠️ Common Commands

```bash
# Basic
python test_my_data.py data.csv

# Specify column
python test_my_data.py data.csv --column "text"

# Limit rows
python test_my_data.py data.csv --limit 500

# Choose filters
python test_my_data.py data.csv --filters "ban,safe"

# Choose formats
python test_my_data.py data.csv --formats "csv,json"
```

---

## 📁 Output Files

| File | Purpose |
|------|---------|
| `*_report_*.csv` | All results |
| `*_MASTERS_*.csv` | Unique only |
| `*_BAN_*.csv` | Toxic only |
| `*_SAFE_*.csv` | Clean only |

---

## 🔑 Your Trial Key

- **Key:** Pre-configured in script
- **Quota:** 10,000 queries
- **Check usage:** 
  ```
  https://www.hiwosy.com/api/usage?api_key=YOUR_KEY
  ```

---

## 📞 Need Help?

**Website:** https://www.hiwosy.com
**Email:** contact@hiwosy.com

---

*© 2025 HIWOSY™*

