```
================================================================================
HIWOSY™ MEMORY LAYER  V R C R
================================================================================
Self-Learning Semantic Deduplication Technology

Patent Pending: USPTO 63/911,048, 63/915,918, 63/921,878
Copyright Cases: 1-15035049381, 1-15034439898
Contact: Ljubisa Kovacevic | kovalubo@gmail.com
================================================================================
```

# 🧠 HIWOSY™ Trial Package
## 3 Products • 1 API Key • 10,000 Free Queries

Welcome to Hiwosy - the Unified Semantic Intelligence API!

---

## ⚡ Quick Start (2 Minutes)

### Step 1: Install Dependencies

```bash
pip install -r requirements.txt
```

### Step 2: Test with Sample Data

```bash
python test_my_data.py sample_data.csv
```

### Step 3: Test with YOUR Data

```bash
python test_my_data.py your_file.csv
```

---

## ⚠️ IMPORTANT: Data Format Requirement

### **The API reads the FIRST COLUMN of your CSV by default!**

✅ **CORRECT** - Text data in FIRST column:
```csv
message,id,timestamp
"Hello world",1,2026-01-09
"How are you",2,2026-01-09
"What is the price",3,2026-01-09
```

❌ **WRONG** - Text data NOT in first column:
```csv
id,timestamp,message
1,2026-01-09,"Hello world"
2,2026-01-09,"How are you"
3,2026-01-09,"What is the price"
```

### If your text is NOT in the first column:

Use the `--column` flag to specify which column contains your text:

```bash
python test_my_data.py your_file.csv --column "message"
```

### Auto-detected Column Names:
If your column is named any of these, it will be auto-detected:
- query, text, content, message, instruction
- question, ticket, description, body, comment
- review, feedback, input, prompt, notes

---

## 🎯 What You Get (3 Products in 1 API)

| Product | What It Does | Output |
|---------|-------------|--------|
| **1. Deduplication** | Finds similar content | MASTER / MERGE |
| **2. Cache** | Reduces API costs | HIT / MISS |
| **3. Toxicity** | Detects toxic content | SAFE / BAN / WARN |

---

## 📊 Output Files Generated

After running, you get these files:

### Core Reports:
| File | Description |
|------|-------------|
| `hiwosy_report_*.json` | Full results with metadata |
| `hiwosy_report_*.csv` | Per-query details |
| `hiwosy_report_*.xlsx` | Excel for Power BI |
| `hiwosy_report_*.html` | Visual dashboard |

### Filtered Reports (Separated by Category):
| File | Contains |
|------|----------|
| `hiwosy_MASTERS_*.*` | Only unique/original queries |
| `hiwosy_DUPLICATES_*.*` | Only duplicate queries |
| `hiwosy_BAN_*.*` | High toxicity - ban recommended |
| `hiwosy_WARNING_*.*` | Medium toxicity - warning |
| `hiwosy_SAFE_*.*` | Clean content |

---

## 🔑 Your Trial API Key

**Key:** `hiwosy_demo_public_10k`
**Quota:** 10,000 free queries
**Products:** All 3 products enabled
**Rate Limit:** 100 queries/second

The key is pre-configured in `test_my_data.py` - no setup needed!

### Check Your Usage:
```bash
curl "https://www.hiwosy.com/api/usage?api_key=hiwosy_demo_public_10k"
```

---

## 🛠️ Command-Line Options

```bash
# Basic usage
python test_my_data.py your_file.csv

# Specify text column
python test_my_data.py your_file.csv --column "message"

# Limit rows processed
python test_my_data.py your_file.csv --limit 1000

# Choose output filters
python test_my_data.py your_file.csv --filters "masters,ban,safe"

# Choose output formats
python test_my_data.py your_file.csv --formats "csv,json,xlsx"

# Combine options
python test_my_data.py data.csv --column "text" --limit 500 --formats "csv,json"
```

---

## 📁 Package Contents

```
hiwosy_trial_package/
├── README.md              ← You are here
├── test_my_data.py        ← Main test script
├── requirements.txt       ← Python dependencies
├── sample_data.csv        ← 100 sample queries to test
└── QUICK_REFERENCE.md     ← One-page cheat sheet
```

---

## 💡 Example Use Cases

1. **Customer Support** - Deduplicate support tickets
2. **Gaming** - Detect toxic chat messages
3. **API Optimization** - Cache similar queries
4. **Data Cleaning** - Remove duplicate survey responses
5. **Content Moderation** - Auto-flag harmful content

---

## 📞 Need More Queries?

Contact us for enterprise plans:

- **Website:** https://www.hiwosy.com
- **Email:** contact@hiwosy.com

### Enterprise Benefits:
- Unlimited queries
- Priority support
- Custom thresholds
- Dedicated API key
- SLA guarantee

---

## 📜 Terms of Use

This trial package is for evaluation purposes only.
- 10,000 query limit
- Non-commercial testing
- API key may be deactivated if abused

For production use, please contact us for a commercial license.

---

```
================================================================================
HIWOSY™ MEMORY LAYER  V R C R
================================================================================
Self-Learning Semantic Deduplication Technology

Patent Pending: USPTO 63/911,048, 63/915,918, 63/921,878
Copyright Cases: 1-15035049381, 1-15034439898
Contact: Ljubisa Kovacevic | kovalubo@gmail.com
================================================================================
```

© 2026 HIWOSY™ - Unified Semantic Intelligence API
https://www.hiwosy.com

